exception BadArgument of int;

fun fact n = if n = 0 then 1 else n * fact (n - 1);
fact 1;
fact 5;
fact ~1;

fun fact n = if n < 0 then raise BadArgument n else if n = 0 then 1 else n * fact (n - 1);
fact 5;
fact ~1;

fun useFact n =
    "Answer = " ^ Int.toString (fact n)
    handle BadArgument n => "Bad argument " ^ (Int.toString n);

useFact 5;
useFact ~1;

fun safeFact n =
    fact n
    handle BadArgument n => fact ((~1) * n);

safeFact 5;
safeFact ~5;
